
#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion
namespace gov.va.med.vbecs.DAL.UnitTests
{

	
	

	[TestFixture]
	public class DAL_DailyControl : BaseTest 
	{

		private DataTable _dtReagentTestParameter;
		private DataTable _dtDailyControl;
		

		[SetUp]
		protected void SetUp() 
		{				
			this.BaseSetUp();

			if (this.RefreshData)
			{
				this._dtReagentTestParameter = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM ReagentTestParameter WHERE RecordStatusCode = 'A' AND DivisionCode = '" + UnitTestConfig.TestDivisionCode + "'", true);

				//DailyControl
				this._dtDailyControl = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM DailyControl WHERE RecordStatusCode = 'A' AND DivisionCode = '" + UnitTestConfig.TestDivisionCode + "'", true);

				this.RefreshData = false;
			}

		}


		[Test]
		public void SaveAllDailyControlData_Pass()
		{
			this.RefreshData = true;

			System.Guid dcGuid = DataCreator.GetRecordGuid("SELECT TOP 1 DailyControlGuid FROM Rack WHERE RecordStatusCode = 'A' AND DivisionCode = '" + this.TestDivisionCode + "' AND DailyControlGuid IN (SELECT DailyControlGuid From DailyControl WHERE RecordStatusCode = 'A')");
			DataTable dtRack = DAL.Rack.GetConfigurableRackQC(dcGuid);
			DataTable dtReagent = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM ReagentTestParameter WHERE RecordStatusCode = 'A' AND DivisionCode = '" + this.TestDivisionCode + "'");
			dtReagent.Columns.Remove(TABLES.ReagentTestParameter.RowVersion);
			dtReagent.Rows[0][TABLES.ReagentTestParameter.ReagentTestParameterGuid] = System.Guid.NewGuid();

			DataTable dtInsDC = SprocHelper.GetInsertDailyControlSprocTable();
			DataTable dtUpdDC = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM DailyControl WHERE RecordStatusCode = 'A' AND DivisionCode = '" + this.TestDivisionCode + "'");
			dtUpdDC.Rows[0][TABLES.DailyControl.Comments] = "UT1158-" + System.DateTime.Now.ToString();

			bool retValue = DAL.DailyControl.SaveAllDailyControlData(true, dtRack, dtReagent, Common.UpdateFunction.UnitTests, dtInsDC, dtUpdDC);
			
			Assert.AreEqual(true, retValue, "ReturnValue");
		}

		[Test]
		[ExpectedException(typeof(Common.RowVersionException))]
		public void SaveAllDailyControlData_Fail()
		{
			System.Guid dcGuid = DataCreator.GetRecordGuid("SELECT TOP 1 DailyControlGuid FROM Rack WHERE RecordStatusCode = 'A' AND DivisionCode = '" + this.TestDivisionCode + "' AND DailyControlGuid IN (SELECT DailyControlGuid From DailyControl WHERE RecordStatusCode = 'A')");
			DataTable dtRack = DAL.Rack.GetConfigurableRackQC(dcGuid);
			DataTable dtReagent = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM ReagentTestParameter WHERE RecordStatusCode = 'A' AND DivisionCode = '" + this.TestDivisionCode + "'");
			dtReagent.Columns.Remove(TABLES.ReagentTestParameter.RowVersion);
			dtReagent.Rows[0][TABLES.ReagentTestParameter.ReagentTestParameterGuid] = System.Guid.NewGuid();

			DataTable dtInsDC = SprocHelper.GetInsertDailyControlSprocTable();
			DataTable dtUpdDC = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM DailyControl WHERE RecordStatusCode = 'A' AND DivisionCode = '" + this.TestDivisionCode + "'");
			dtUpdDC.Rows[0][TABLES.DailyControl.RowVersion] = new byte[8];

			DAL.DailyControl.SaveAllDailyControlData(true, dtRack, dtReagent, Common.UpdateFunction.UnitTests, dtInsDC, dtUpdDC);
			
		}

		[Test]
		public void GetDailyControlByGuid_Pass()
		{
			System.Guid unitGuid = (System.Guid)this._dtDailyControl.Rows[0][TABLES.DailyControl.DailyControlGuid];
			DataTable dtTest = DAL.DailyControl.GetDailyControlByGuid(unitGuid);

			Assert.IsTrue(dtTest.Rows.Count > 0);
			Assert.IsTrue(dtTest.Columns.Count == 11);
			Assert.IsTrue(dtTest.Columns.Contains(TABLES.DailyControl.DailyControlGuid));
			Assert.IsTrue(dtTest.Columns.Contains(TABLES.DailyControl.NumberOfRacks));
			Assert.IsTrue(dtTest.Columns.Contains(TABLES.DailyControl.DailyAlertTime));
			Assert.IsTrue(dtTest.Columns.Contains(TABLES.DailyControl.RackNamesIndicator));
			Assert.IsTrue(dtTest.Columns.Contains(TABLES.DailyControl.CommercialTemplateIndicator));
			Assert.IsTrue(dtTest.Columns.Contains(TABLES.DailyControl.PrimaryEnhancementMediaId));
			Assert.IsTrue(dtTest.Columns.Contains(TABLES.DailyControl.SecondaryEnhancementMediaId));
			Assert.IsTrue(dtTest.Columns.Contains(TABLES.DailyControl.DivisionCode));
			Assert.IsTrue(dtTest.Columns.Contains(TABLES.DailyControl.RecordStatusCode));
			Assert.IsTrue(dtTest.Columns.Contains(TABLES.DailyControl.Comments));
		}

		[Test]
		public void GetAllRacks_Pass()
		{
			Assert.IsNotNull(DAL.DailyControl.GetAllRacks());
		}
		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetAllRacks_Fail()
		{
		}

		[Test]
		public void GetPartiallyCompletedQC_Pass()
		{
			Assert.IsNotNull(DAL.DailyControl.GetPartiallyCompletedQC());
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetPartiallyCompletedQC_Fail()
		{
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetEmptyDailyControlTableSchema_Fail()
		{
		}

		[Test]
		public void GetEmptyDailyControlTableSchema_Pass()
		{
			DataTable dtTest = DAL.DailyControl.GetEmptyDailyControlTableSchema(true);

			Assert.IsTrue(dtTest.Columns.Count > 0);
			Assert.IsTrue(dtTest.Columns.Count == 12);
			Assert.IsTrue(dtTest.Columns.Contains(TABLES.DailyControl.DailyControlGuid));
			Assert.IsTrue(dtTest.Columns.Contains(TABLES.DailyControl.NumberOfRacks));
			Assert.IsTrue(dtTest.Columns.Contains(TABLES.DailyControl.DailyAlertTime));
			Assert.IsTrue(dtTest.Columns.Contains(TABLES.DailyControl.RackNamesIndicator));
			Assert.IsTrue(dtTest.Columns.Contains(TABLES.DailyControl.CommercialTemplateIndicator));
			Assert.IsTrue(dtTest.Columns.Contains(TABLES.DailyControl.PrimaryEnhancementMediaId));
			Assert.IsTrue(dtTest.Columns.Contains(TABLES.DailyControl.SecondaryEnhancementMediaId));
			Assert.IsTrue(dtTest.Columns.Contains(TABLES.DailyControl.DivisionCode));
			Assert.IsTrue(dtTest.Columns.Contains(TABLES.DailyControl.RecordStatusCode));
			Assert.IsTrue(dtTest.Columns.Contains(TABLES.DailyControl.Comments));
			Assert.IsTrue(dtTest.Columns.Contains(TABLES.DailyControl.LastUpdateFunctionId));
			Assert.IsTrue(dtTest.Columns.Contains(TABLES.DailyControl.RowVersion));
		}


		[Test]
		public void GetDailyControlByGuid_Fail()
		{
			DataTable dtTest = DAL.DailyControl.GetDailyControlByGuid(System.Guid.NewGuid());
			Assert.IsTrue(dtTest.Rows.Count == 0);
		}

		[Test]
		public void GetDailyControl_Pass()
		{
			DataTable dtTest = DAL.DailyControl.GetDailyControl();

			Assert.IsTrue(dtTest.Rows.Count > 0);
			Assert.IsTrue(dtTest.Columns.Count == 11);
			Assert.IsTrue(dtTest.Columns.Contains(TABLES.DailyControl.DailyControlGuid));
			Assert.IsTrue(dtTest.Columns.Contains(TABLES.DailyControl.NumberOfRacks));
			Assert.IsTrue(dtTest.Columns.Contains(TABLES.DailyControl.DailyAlertTime));
			Assert.IsTrue(dtTest.Columns.Contains(TABLES.DailyControl.RackNamesIndicator));
			Assert.IsTrue(dtTest.Columns.Contains(TABLES.DailyControl.CommercialTemplateIndicator));
			Assert.IsTrue(dtTest.Columns.Contains(TABLES.DailyControl.PrimaryEnhancementMediaId));
			Assert.IsTrue(dtTest.Columns.Contains(TABLES.DailyControl.SecondaryEnhancementMediaId));
			Assert.IsTrue(dtTest.Columns.Contains(TABLES.DailyControl.DivisionCode));
			Assert.IsTrue(dtTest.Columns.Contains(TABLES.DailyControl.RecordStatusCode));
			Assert.IsTrue(dtTest.Columns.Contains(TABLES.DailyControl.Comments));
			Assert.IsTrue(dtTest.Columns.Contains(TABLES.DailyControl.RowVersion));
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetDailyControl_Fail()
		{
		}

	}
}
#endif


